/*
 * Decompiled with CFR 0.152.
 */
package com.genymobile.genymotion.ide.eclipse;

import com.genymobile.genymotion.lib.IdeConsole;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.ui.console.MessageConsoleStream;

public class EclipseConsole
extends IdeConsole {
    private MessageConsoleStream console;
    private BufferedWriter output;
    private String output_file;

    public EclipseConsole(MessageConsoleStream eclipseConsole) {
        this.console = eclipseConsole;
        this.output = null;
        this.output_file = String.valueOf(System.getProperty("user.home")) + File.separator + ".genymotion-eclipse.log";
        this.print("Output file: " + this.output_file + "\n");
        try {
            this.output = new BufferedWriter(new FileWriter(this.output_file, false));
        }
        catch (Exception ex) {
            System.err.println(String.valueOf(this.output_file) + ": unable to open file: " + ex.toString());
        }
    }

    protected void finalize() throws Throwable {
        if (this.output != null) {
            this.output.close();
        }
    }

    public void print(String message) {
        if (this.console == null) {
            return;
        }
        this.console.print(message);
        try {
            this.console.flush();
        }
        catch (IOException e1) {
            System.err.println("Console: unable to flush data: " + e1.toString());
        }
        if (this.output != null) {
            try {
                this.output.write(message);
                this.output.flush();
            }
            catch (IOException e) {
                System.err.println(String.valueOf(this.output_file) + ": unable to write log in file: " + e.toString());
            }
        }
    }
}

