/*
 * Decompiled with CFR 0.152.
 */
package com.genymobile.genymotion.ide.eclipse.actions;

import com.genymobile.genymotion.ide.eclipse.EclipseConsole;
import com.genymobile.genymotion.ide.eclipse.GenymotionPlugin;
import com.genymobile.genymotion.ide.eclipse.preferences.GenymotionPage;
import com.genymobile.genymotion.ide.eclipse.preferences.MainPage;
import com.genymobile.genymotion.lib.IdeConsole;
import com.genymobile.genymotion.lib.Utils;
import com.genymobile.genymotion.lib.VMToolsEngine;
import com.genymobile.genymotion.lib.VMToolsMachine;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class GenymotionHandler
extends AbstractHandler {
    private VMToolsEngine engine;
    private VMToolsMachine[] devices;
    Label topLabel;
    Label bottomLabel;
    IdeConsole console = new EclipseConsole(GenymotionPlugin.findConsole().newMessageStream());

    private boolean loadLibrary() {
        if (VMToolsEngine.isInit()) {
            return true;
        }
        this.console.println("Loading Genymotion library");
        String launchpadPath = this.getLaunchpadDirFromPrefs();
        if (launchpadPath == null) {
            this.displaySetPreferenceLaunchpadDir();
            return false;
        }
        this.engine = new VMToolsEngine(launchpadPath, this.console);
        this.console.println("Trying to initialize engine");
        if (!this.engine.initialize()) {
            this.console.println("Initialize Engine: failed");
            return false;
        }
        this.console.println("Initialize Engine: success");
        return true;
    }

    public Object execute(ExecutionEvent event) {
        if (!this.loadLibrary()) {
            return null;
        }
        final Display display = PlatformUI.getWorkbench().getDisplay();
        Shell shell = new Shell(display, 67696);
        Rectangle screenSize = display.getPrimaryMonitor().getBounds();
        shell.setSize(Math.max(screenSize.width * 45 / 100, 900), Math.max(screenSize.height * 45 / 100, 500));
        shell.setText("Genymotion Virtual Devices Manager");
        GridLayout layout = new GridLayout(2, false);
        shell.setLayout((Layout)layout);
        this.topLabel = new Label((Composite)shell, 64);
        this.topLabel.setText("List of available Genymotion virtual devices");
        GridData topLabelGridData = new GridData();
        topLabelGridData.horizontalSpan = 2;
        this.topLabel.setLayoutData((Object)topLabelGridData);
        final Table table = new Table((Composite)shell, 67586);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        table.setLayoutData((Object)data);
        String[] titles = new String[]{"Name", "AOSP Version", "Genymotion version", "IP Address", "State"};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            ++i;
        }
        Composite c = new Composite((Composite)shell, 0);
        RowLayout buttons = new RowLayout(512);
        buttons.fill = true;
        c.setLayout((Layout)buttons);
        final String pluginVersion = (String)GenymotionPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
        String tmpIDE = "Eclipse variant";
        try {
            tmpIDE = Platform.getProduct().getName();
        }
        catch (Exception exception) {}
        final String ide = tmpIDE;
        Button bNew = new Button(c, 8);
        bNew.setText("New...");
        bNew.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    new ProcessBuilder(new String[0]).command(String.valueOf(GenymotionHandler.this.engine.getGenymotionPath()) + "/genymotion", "--open-wizard", "--from-plugin=" + pluginVersion, "--ide", ide).start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    GenymotionHandler.this.console.println("Run Genymotion wizard: failed: " + e.toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button bStart = new Button(c, 8);
        bStart.setEnabled(false);
        bStart.setText("Start...");
        bStart.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                final String deviceName = table.getSelection()[0].getText();
                GenymotionHandler.this.console.println("Starting device: " + deviceName);
                GenymotionHandler.this.bottomLabel.setText("Starting device: " + deviceName + ". Please wait...");
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String playerFolder = GenymotionHandler.this.getLaunchpadDirFromPrefs();
                        if (Utils.isMac() && new File(String.valueOf(playerFolder) + File.separator + "player.app").exists()) {
                            playerFolder = String.valueOf(playerFolder) + File.separator + "player.app" + File.separator + "Contents" + File.separator + "MacOS";
                        }
                        GenymotionHandler.this.engine.startMachine(deviceName, playerFolder, pluginVersion, ide);
                        (this).GenymotionHandler.this.console.println("Device [" + deviceName + "]: started");
                        GenymotionHandler.this.resetBottomLabel(0);
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button bRefresh = new Button(c, 8);
        bRefresh.setText("Refresh");
        bRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenymotionHandler.this.bottomLabel.setText("Refreshing list of devices. Please wait...");
                GenymotionHandler.this.console.println("Try to refresh...");
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GenymotionHandler.this.updateVirtualDevicesList(table);
                        GenymotionHandler.this.updateStartButton(table, bStart);
                        GenymotionHandler.this.resetBottomLabel(0);
                        (this).GenymotionHandler.this.console.println("Refresh: success");
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GenymotionHandler.this.updateStartButton(table, bStart);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        table.removeAll();
        TableItem item = new TableItem(table, 128);
        item.setText(3, "Please wait...");
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
        this.bottomLabel = new Label((Composite)shell, 64);
        GridData bottomLabelGridData = new GridData();
        bottomLabelGridData.horizontalSpan = 2;
        this.bottomLabel.setLayoutData((Object)bottomLabelGridData);
        this.bottomLabel.setText("Refreshing list of devices. Please wait...");
        shell.open();
        if (VMToolsEngine.isInit()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GenymotionHandler.this.updateVirtualDevicesList(table);
                    GenymotionHandler.this.updateStartButton(table, bStart);
                    GenymotionHandler.this.resetBottomLabel(0);
                }
            });
        }
        return null;
    }

    private void updateStartButton(Table table, Button bStart) {
        int idDevice = table.getSelectionIndex();
        if (idDevice < 0) {
            bStart.setEnabled(false);
        } else {
            boolean isRunning = this.devices[idDevice].status == VMToolsMachine.Status.On;
            bStart.setEnabled(!isRunning);
        }
    }

    private void updateVirtualDevicesList(Table table) {
        this.devices = this.engine.getMachines();
        if (this.devices == null) {
            this.console.println("[Error] Genymotion plugin has been unable to retrieve list of virtual devices");
            return;
        }
        table.removeAll();
        int i = 0;
        while (i < this.devices.length) {
            TableItem item = new TableItem(table, 128);
            item.setText(0, this.devices[i].name);
            item.setText(1, this.devices[i].androidVersion);
            item.setText(2, this.devices[i].genymotionVersion);
            item.setText(3, this.devices[i].getIPAddress());
            item.setText(4, this.devices[i].getStatus().toString());
            this.console.print("[INFO] device number " + i + ": ");
            this.console.print("[" + this.devices[i].name + "]");
            this.console.print("[" + this.devices[i].androidVersion + "]");
            this.console.print("[" + this.devices[i].genymotionVersion + "]");
            this.console.print("[" + this.devices[i].getIPAddress() + "]");
            this.console.println("[" + this.devices[i].getStatus().toString() + "]");
            ++i;
        }
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
    }

    private String getLaunchpadDirFromPrefs() {
        File d;
        String launchpadDir;
        try {
            launchpadDir = GenymotionPlugin.getDefault().getPreferenceStore().getString("pathLaunchpadDir");
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)new Shell(), (String)"Error while reading setting", (String)("Unable to read setting (pathLaunchpadDir): " + e.toString()));
            return null;
        }
        launchpadDir = launchpadDir.trim();
        if (launchpadDir == "") {
            MessageDialog.openError((Shell)new Shell(), (String)"Error while reading setting", (String)"In Genymotion settings, Genymotion directory is not set.\n\nPlease, choose OK to set this preference.");
            return null;
        }
        if (Utils.isMac()) {
            launchpadDir = String.valueOf(launchpadDir) + File.separator + "Contents" + File.separator + "MacOS";
        }
        if (!(d = new File(launchpadDir)).exists()) {
            MessageDialog.openError((Shell)new Shell(), (String)"Error reading setting", (String)"In Genymotion settings, Genymotion directory is not valid. Please fix the value.");
            return null;
        }
        return launchpadDir;
    }

    private void displaySetPreferenceLaunchpadDir() {
        MainPage genymobilePage = new MainPage();
        GenymotionPage genymotionPage = new GenymotionPage();
        genymobilePage.setTitle("Genymobile");
        genymotionPage.setTitle("Genymotion");
        PreferenceNode genymobileNode = new PreferenceNode("node1", (IPreferencePage)genymobilePage);
        PreferenceNode genymotionNode = new PreferenceNode("node2", (IPreferencePage)genymotionPage);
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)genymobileNode);
        pm.addTo(genymobileNode.getId(), (IPreferenceNode)genymotionNode);
        PreferenceDialog pd = new PreferenceDialog(null, pm);
        pd.setSelectedNode(genymotionNode.getId());
        pd.setPreferenceStore(GenymotionPlugin.getDefault().getPreferenceStore());
        pd.create();
        pd.open();
    }

    private void resetBottomLabel(final int delay) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {}
                GenymotionHandler.this.bottomLabel.setText("Ready. Please select a virtual device before doing any action.");
                GenymotionHandler.this.bottomLabel.pack();
            }
        });
    }
}

