Given the new onslaught of issues that folks in the community are filing, we thought it might be good to explain some of our 
bug labeling and triaging practices to the community. 

## Bug Triaging Overview
Every week, there is a new "bug sheriff" (assigned from the core Lighthouse team) and their job is to go through and triage incoming bugs and pay attention to bugs
where we need more information from the reporter. Therefore, depending on the week, you might be hearing from a different 
bug sheriff about your bug. 

## Labeling Bugs

Here are the different (actively used) labels and what they mean, organized by category bucket: 

### Priority Labels
- P0: Urgent issue- drop everything and deal with immediately
- P1: We want to work on this in the next few weeks
- P1.5: We want to work on this in the next few months
- P2: We want to work on this in the next few quarters. 
- P3: Good idea, useful for future thinking. 

### Process labels 
- Needs more information: issue that hasn't been prioritized yet because we need more information from the bug creator. If we don't hear back in 2 weeks, we will close out the bug. 
- Pending close: issue that we will soon close. 
- Needs priority: issue that needs to be prioritized by team (as P0, P1, P1.5, etc.)
- Needs investigation: issue that we need to dig into to understand what is going on (mostly for bugs)

### Type of incoming issue labels
- Bug: something is wrong on our end and needs to be fixed. 
- Feature: suggestion of new thing to implement. 
- Internal cleanup: nothing is wrong but clean up and/or refactor of the existing way we're doing something. 
- Question: question from community. Good fodder for new documentation that needs to be written. 

### Other labels
- Good first issue: for new external contributor, these issues can be useful for them to tackle. 
- Help wanted: issues that could use help from the community. 

